<?php

namespace MediaLibrary;

use Ygs\CoreServices\Hooks\PanelExtensionHooks;
use MediaLibrary\Resources\MediaResource;

class ServiceProvider extends \Illuminate\Support\ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register MediaResource via PanelExtensionHooks
        if (class_exists(PanelExtensionHooks::class)) {
            PanelExtensionHooks::addResources(function($resources) {
                $resources[] = MediaResource::class;
                return $resources;
            }, 10);
        }
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');

        // Load views if they exist
        if (is_dir(__DIR__ . '/../resources/views')) {
            $this->loadViewsFrom(__DIR__ . '/../resources/views', 'media-library');
        }
    }
}

