<?php

namespace MediaLibrary\Resources\MediaResource\Pages;

use MediaLibrary\Resources\MediaResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Resources\Components\Tab;
use Illuminate\Database\Eloquent\Builder;
use MediaLibrary\Models\Media;

class ListMedia extends ListRecords
{
    protected static string $resource = MediaResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            'all' => Tab::make('All Media')
                ->icon('heroicon-o-photo'),
            
            'images' => Tab::make('Images')
                ->icon('heroicon-o-photo')
                ->modifyQueryUsing(fn (Builder $query) => $query->images())
                ->badge(Media::images()->count()),
            
            'videos' => Tab::make('Videos')
                ->icon('heroicon-o-video-camera')
                ->modifyQueryUsing(fn (Builder $query) => $query->videos())
                ->badge(Media::videos()->count()),
            
            'documents' => Tab::make('Documents')
                ->icon('heroicon-o-document')
                ->modifyQueryUsing(fn (Builder $query) => $query->documents())
                ->badge(Media::documents()->count()),
        ];
    }
}

