<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('custom_media', function (Blueprint $table) {
            $table->bigIncrements('id');
            
            // Custom fields for our media system
            $table->string('title')->nullable();
            $table->string('alt_text')->nullable();
            $table->text('caption')->nullable();
            $table->text('description')->nullable();
            $table->string('link_url')->nullable();
            $table->enum('link_target', ['_self', '_blank'])->default('_self');
            $table->unsignedBigInteger('staff_id')->nullable();
            
            // File information
            $table->string('file_name');
            $table->string('file_path');
            $table->string('mime_type')->nullable();
            $table->unsignedBigInteger('file_size')->nullable();
            $table->string('disk')->default('public');
            
            // WordPress-style organization
            $table->string('year_month_path')->nullable(); // YYYY/MM format
            
            $table->timestamps();
            
            // Foreign key constraint
            $table->foreign('staff_id')->references('id')->on('lunar_staff')->onDelete('set null');
            
            // Indexes
            $table->index(['staff_id']);
            $table->index(['year_month_path']);
            $table->index(['mime_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('custom_media');
    }
};

