# Media Library Plugin

WordPress-style media library plugin with thumbnail generation and staff attribution for the YGS Order Platform.

## Installation

### Via Plugin Management Site

1. Visit the [Plugin Management Site](https://plugins.gregoryscottdev.com)
2. Browse to the Media Library plugin
3. Click "Download" to get the latest version
4. In your order-platform admin panel, go to Plugins
5. Click "Install Plugin" and upload the downloaded ZIP file
6. Activate the plugin

### Manual Installation

1. Download the latest release ZIP from [GitHub Releases](https://github.com/TheYGSGroup/media-plugin/releases)
2. In your order-platform admin panel, go to Plugins
3. Click "Install Plugin" and upload the ZIP file
4. Activate the plugin

## Configuration

After installation, the plugin is ready to use. No additional configuration is required.

The plugin will automatically:
- Create the `custom_media` table on activation
- Register the Media Resource in the admin panel under "Content"
- Set up WordPress-style directory structure (`media/YYYY/MM/`)

## Requirements

- PHP >= 8.2
- Laravel >= 10.0
- `ygs/core-services` >= 1.0.0
- `intervention/image` >= 3.0 (must be installed in order-platform's composer.json)

## Features

- ✅ File upload (images, videos, documents)
- ✅ WordPress-style directory organization (`media/YYYY/MM/`)
- ✅ Automatic thumbnail generation (150px, 300px, 1024px)
- ✅ Staff attribution
- ✅ Filament admin interface
- ✅ Filters (file type, year, month, date range)
- ✅ Search functionality
- ✅ Bulk actions (delete)
- ✅ Metadata editing (title, alt text, description)

## Usage

### Uploading Media

1. Navigate to **Content** → **Media** in the admin panel
2. Click **Create** or **New**
3. Select a file to upload
4. Fill in metadata (title, alt text, description)
5. Save

### Managing Media

- **View**: Browse all media files in the Media Library
- **Filter**: Use filters to find specific files by type, year, month, or date range
- **Search**: Search by title or filename
- **Edit**: Click on any media item to edit metadata
- **Delete**: Delete individual files or use bulk actions

### Thumbnails

For image files, the plugin automatically generates three thumbnail sizes:
- **Thumbnail**: 150x150px
- **Medium**: 300x300px
- **Large**: 1024x1024px

Thumbnails are stored alongside the original file in the same directory.

## Development

### Repository Structure

```
media-plugin/
├── src/
│   ├── Plugin.php              # Main plugin class
│   ├── ServiceProvider.php     # Laravel service provider
│   ├── Models/
│   │   └── Media.php          # Media model
│   ├── Services/
│   │   └── MediaService.php   # Media service (upload, delete, thumbnails)
│   └── Resources/
│       ├── MediaResource.php  # Filament resource
│       └── MediaResource/Pages/
│           ├── ListMedia.php
│           ├── CreateMedia.php
│           └── EditMedia.php
├── database/
│   └── migrations/
│       └── 2025_12_22_170000_create_custom_media_table.php
├── plugin.json                 # Plugin metadata
├── README.md
└── CHANGELOG.md
```

### Building

The plugin is automatically built and deployed when you create a Git tag:

```bash
git tag v1.0.0
git push origin v1.0.0
```

Or manually trigger via GitHub Actions workflow dispatch.

## License

Proprietary - YGS

