# Media Plugin - Deployment Ready ✅

**Date**: December 22, 2025  
**Status**: Ready for first deployment

## Repository Setup Complete

✅ **Repository**: `git@github.com:TheYGSGroup/media-plugin.git`  
✅ **Initial Commit**: Pushed to `main` branch  
✅ **Structure**: Matches other plugin repos (authnet-payment-plugin, fedex-shipping-plugin)  
✅ **Workflow**: `.github/workflows/build-and-deploy.yml` configured

## Required GitHub Secrets

The following secrets need to be configured in the GitHub repository settings:

### Required Secrets

1. **`SSH_PRIVATE_KEY`**
   - SSH private key for accessing the plugin management site server
   - Same as used in other plugin repos

2. **`HOST`**
   - Hostname/IP of the plugin management site server
   - Example: `4.227.165.146` (or your server IP)

3. **`USER`**
   - SSH username for the plugin management site server
   - Example: `gregoryscottdev`

4. **`PORT`** (optional, defaults to 22)
   - SSH port for the plugin management site server
   - Default: `22`

5. **`PLUGIN_MGMT_PATH`**
   - Base path to the plugin management site deployment
   - Example: `/home/gregoryscottdev/deploy/plugin-management-site`

6. **`PLUGIN_MGMT_URL`** (optional, defaults to `https://plugins.gregoryscottdev.com`)
   - URL of the plugin management site API
   - Default: `https://plugins.gregoryscottdev.com`

7. **`DEPLOYMENT_API_KEY`**
   - API key for authenticating with the plugin management site deployment API
   - Used to register plugins after deployment

## How to Set Secrets

1. Go to: `https://github.com/TheYGSGroup/media-plugin/settings/secrets/actions`
2. Click **"New repository secret"**
3. Add each secret listed above
4. Use the same values as configured in `authnet-payment-plugin` or `fedex-shipping-plugin`

## First Deployment

Once secrets are configured, deploy the plugin by creating a version tag:

```bash
git tag v1.0.0
git push origin v1.0.0
```

Or trigger manually via GitHub Actions:
1. Go to **Actions** tab
2. Select **"Build and Deploy Plugin"** workflow
3. Click **"Run workflow"**
4. Enter version: `1.0.0`
5. Click **"Run workflow"**

## What Happens on Deployment

1. ✅ Plugin ZIP is built (excludes git, vendor, node_modules)
2. ✅ ZIP is uploaded as GitHub artifact
3. ✅ ZIP is deployed to plugin management site storage
4. ✅ Plugin is registered via API in plugin management site
5. ✅ GitHub Release is created with the ZIP attached

## Verification

After deployment, verify:
- ✅ Plugin appears in plugin management site
- ✅ ZIP file is downloadable
- ✅ GitHub Release is created
- ✅ Plugin can be installed in order-platform

## Next Steps

1. **Set GitHub Secrets** (see above)
2. **Create first tag**: `git tag v1.0.0 && git push origin v1.0.0`
3. **Verify deployment** in plugin management site
4. **Test installation** in order-platform

## Notes

- Plugin follows the same structure and deployment pattern as other plugins
- Uses the same workflow file as `authnet-payment-plugin` and `fedex-shipping-plugin`
- All code has been migrated from `order-platform/plugins/media-library/`
- Ready for production use once secrets are configured

