# FedEx Shipping Integration Plugin

FedEx shipping rate calculation and address validation plugin for the YGS Order Platform.

## Installation

### Via Plugin Management Site

1. Visit the [Plugin Management Site](https://plugins.gregoryscottdev.com)
2. Browse to the FedEx Shipping Integration plugin
3. Click "Download" to get the latest version
4. In your order-platform admin panel, go to Plugins
5. Click "Install Plugin" and upload the downloaded ZIP file
6. Activate the plugin

### Manual Installation

1. Download the latest release ZIP from [GitHub Releases](https://github.com/TheYGSGroup/fedex-shipping-plugin/releases)
2. In your order-platform admin panel, go to Plugins
3. Click "Install Plugin" and upload the ZIP file
4. Activate the plugin

## Configuration

After installation, configure the plugin in the Global Settings page:

- **Client ID** - Your FedEx API Client ID
- **Client Secret** - Your FedEx API Client Secret
- **Account Number** - Your FedEx Account Number
- **Base URL** - Sandbox or production endpoint
- **Enable Shipping** - Toggle to enable/disable the shipping integration

## Requirements

- PHP >= 8.2
- Laravel >= 11.0
- `ygs/core-services` >= 1.0.0

## Features

- ✅ Real-time shipping rate calculation
- ✅ Address validation
- ✅ Multiple FedEx service types
- ✅ Caching for performance
- ✅ Integration with order-platform hook system

## Development

### Repository Structure

```
fedex-shipping-plugin/
├── src/
│   ├── Plugin.php              # Main plugin class
│   ├── ServiceProvider.php     # Laravel service provider
│   ├── Modifiers/
│   │   └── FedExShippingModifier.php
│   └── Services/
│       ├── FedExService.php
│       ├── FedExQuoteCalculator.php
│       └── FedExCacheManager.php
├── plugin.json                 # Plugin metadata
├── README.md
└── CHANGELOG.md
```

### Building

The plugin is automatically built and deployed when you create a Git tag:

```bash
git tag v1.0.1
git push origin v1.0.1
```

This will:
1. Build a ZIP file
2. Deploy it to the plugin management site
3. Create a GitHub release

## License

Proprietary - YGS Group
