<?php

namespace AuthNetPayment;

use Ygs\CoreServices\Facades\HookManager;
use AuthNetPayment\Services\AuthorizeNetGateway;
use Ygs\CoreServices\Payment\Contracts\PaymentGatewayServiceInterface;

class ServiceProvider extends \Illuminate\Support\ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register the payment gateway when payment gateways are being registered
        HookManager::addAction('payment.gateways.register', function(PaymentGatewayServiceInterface $service) {
            // Get settings interface from container for AuthorizeNetGateway
            $settings = app(\Ygs\CoreServices\Settings\Contracts\SettingsInterface::class);
            $service->register(new AuthorizeNetGateway($settings));
        }, 10);
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Load routes if they exist
        if (file_exists(__DIR__ . '/../routes/api.php')) {
            $this->loadRoutesFrom(__DIR__ . '/../routes/api.php');
        }

        // Load views if they exist
        if (is_dir(__DIR__ . '/../resources/views')) {
            $this->loadViewsFrom(__DIR__ . '/../resources/views', 'authnet-payment');
        }
    }
}

