# Authorize.Net Payment Gateway Plugin

Payment processing plugin for Authorize.Net using Accept.js, designed for the YGS Order Platform.

## Installation

### Via Plugin Management Site

1. Visit the [Plugin Management Site](https://plugins.gregoryscottdev.com)
2. Browse to the Authorize.Net Payment Gateway plugin
3. Click "Download" to get the latest version
4. In your order-platform admin panel, go to Plugins
5. Click "Install Plugin" and upload the downloaded ZIP file
6. Activate the plugin

### Manual Installation

1. Download the latest release ZIP from [GitHub Releases](https://github.com/TheYGSGroup/authnet-payment-plugin/releases)
2. In your order-platform admin panel, go to Plugins
3. Click "Install Plugin" and upload the ZIP file
4. Activate the plugin

## Configuration

After installation, configure the plugin in the Global Settings page:

- **API Login ID** - Your Authorize.Net API Login ID
- **Transaction Key** - Your Authorize.Net Transaction Key
- **Client Key** - Your Authorize.Net Client Key (for Accept.js)
- **Base URL** - Sandbox or production endpoint
- **Enable Gateway** - Toggle to enable/disable the payment gateway

## Requirements

- PHP >= 8.2
- Laravel >= 11.0
- `ygs/core-services` >= 1.0.0
- `authorizenet/authorizenet` package (must be installed in order-platform's composer.json)

## Features

- ✅ Credit card payments via Accept.js
- ✅ Optional pay-by-check method
- ✅ Automatic address validation
- ✅ Transaction logging
- ✅ Integration with order-platform hook system

## Development

### Repository Structure

```
authnet-payment-plugin/
├── src/
│   ├── Plugin.php              # Main plugin class
│   ├── ServiceProvider.php     # Laravel service provider
│   └── Services/
│       └── AuthorizeNetGateway.php
├── plugin.json                 # Plugin metadata
├── README.md
└── CHANGELOG.md
```

### Building

The plugin is automatically built and deployed when you create a Git tag:

```bash
git tag v1.0.1
git push origin v1.0.1
```

This will:
1. Build a ZIP file
2. Deploy it to the plugin management site
3. Create a GitHub release

## License

Proprietary - YGS Group
